/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ProfibusFspmm2_Public.h $
   Last Modification:
    @version $Id: ProfibusFspmm2_Public.h 21804 2012-01-31 11:04:52Z mark $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    Profibus Fspmm2
    public
   
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------        
       10    02.03.08    MK
          - size of abRemSlaveData[] in SET_SLAVE_ADD reduced to 240 bytes
       9     03.09.07    MK
          - Error codes removed to ProfibusFspmm2_error.h
          - New commands LiveList;GetMasterDiag
          - changes in different packet definition!
          - missing packed attributes around structures  
       
       6     09.08.07    MK
          - First Beta Version
     
        
**************************************************************************************/
/**
 * @file ProfibusFspmm2_Public.h
 *  Profibus Fspmm2 - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 * 
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__TLR_PACKED_PRE</code>
 * and <code>__TLR_PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __PROFIBUS_FSPMM2_PUBLIC_H
#define __PROFIBUS_FSPMM2_PUBLIC_H

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'Profibus Fspmm2'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 * 
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 PROFIBUS_FSPMM2_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 * 
 * eRslt = TLS_QUE_IDENTIFY(PROFIBUS_FSPMM2_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define PROFIBUS_FSPMM2_QUEUE_NAME        "FSPMM2_QUE"

/** @} */


/*************************************************************************************/
/* CLASS2 Commands */

#define  PROFIBUS_FSPMM2_CMD_RANGE_START               0x00004400

#define  PROFIBUS_FSPMM2_CMD_INIT_REQ                  0x00004400
#define  PROFIBUS_FSPMM2_CMD_INIT_CNF                  0x00004401

#define  PROFIBUS_FSPMM2_CMD_RESET_REQ                 0x00004402
#define  PROFIBUS_FSPMM2_CMD_RESET_CNF                 0x00004403

#define  PROFIBUS_FSPMM2_CMD_INITIATE_REQ              0x00004404
#define  PROFIBUS_FSPMM2_CMD_INITIATE_CNF              0x00004405

#define  PROFIBUS_FSPMM2_CMD_READ_REQ                  0x00004406
#define  PROFIBUS_FSPMM2_CMD_READ_CNF                  0x00004407

#define  PROFIBUS_FSPMM2_CMD_WRITE_REQ                 0x00004408
#define  PROFIBUS_FSPMM2_CMD_WRITE_CNF                 0x00004409

#define  PROFIBUS_FSPMM2_CMD_DATA_TRANSPORT_REQ        0x0000440A
#define  PROFIBUS_FSPMM2_CMD_DATA_TRANSPORT_CNF        0x0000440B

#define  PROFIBUS_FSPMM2_CMD_ABORT_REQ                 0x0000440C
#define  PROFIBUS_FSPMM2_CMD_ABORT_CNF                 0x0000440D

#define  PROFIBUS_FSPMM2_CMD_READ_SLAVE_DIAG_REQ       0x0000440E
#define  PROFIBUS_FSPMM2_CMD_READ_SLAVE_DIAG_CNF       0x0000440F

#define  PROFIBUS_FSPMM2_CMD_READ_INPUT_REQ            0x00004410
#define  PROFIBUS_FSPMM2_CMD_READ_INPUT_CNF            0x00004411

#define  PROFIBUS_FSPMM2_CMD_READ_OUTPUT_REQ           0x00004412
#define  PROFIBUS_FSPMM2_CMD_READ_OUTPUT_CNF           0x00004413

#define  PROFIBUS_FSPMM2_CMD_GET_CFG_REQ               0x00004414
#define  PROFIBUS_FSPMM2_CMD_GET_CFG_CNF               0x00004415

#define  PROFIBUS_FSPMM2_CMD_SET_SLAVE_ADD_REQ         0x00004416
#define  PROFIBUS_FSPMM2_CMD_SET_SLAVE_ADD_CNF         0x00004417

#define  PROFIBUS_FSPMM2_CMD_GET_MASTER_DIAG_REQ       0x00004418
#define  PROFIBUS_FSPMM2_CMD_GET_MASTER_DIAG_CNF       0x00004419
                                                                                                                                                                                                
#define  PROFIBUS_FSPMM2_CMD_START_SEQ_REQ             0x0000441A
#define  PROFIBUS_FSPMM2_CMD_START_SEQ_CNF             0x0000441B

#define  PROFIBUS_FSPMM2_CMD_DOWNLOAD_REQ              0x0000441C
#define  PROFIBUS_FSPMM2_CMD_DOWNLOAD_CNF              0x0000441D

#define  PROFIBUS_FSPMM2_CMD_UPLOAD_REQ                0x0000441E
#define  PROFIBUS_FSPMM2_CMD_UPLOAD_CNF                0x0000441F

#define  PROFIBUS_FSPMM2_CMD_END_SEQ_REQ               0x00004420
#define  PROFIBUS_FSPMM2_CMD_END_SEQ_CNF               0x00004421
                                                       
#define  PROFIBUS_FSPMM2_CMD_ACT_PARAM_REQ             0x00004422
#define  PROFIBUS_FSPMM2_CMD_ACT_PARAM_CNF             0x00004423
                                                       
#define  PROFIBUS_FSPMM2_CMD_ACT_PARAM_BRCT_REQ        0x00004424
#define  PROFIBUS_FSPMM2_CMD_ACT_PARAM_BRCT_CNF        0x00004425

#define  PROFIBUS_FSPMM2_CMD_ABORT_IND                 0x00004426
#define  PROFIBUS_FSPMM2_CMD_ABORT_RES                 0x00004427

#define  PROFIBUS_FSPMM2_CMD_CLOSED_IND                0x00004428
#define  PROFIBUS_FSPMM2_CMD_CLOSED_RES                0x00004429

#define  PROFIBUS_FSPMM2_CMD_REJECT_IND                0x0000442A
#define  PROFIBUS_FSPMM2_CMD_REJECT_RES                0x0000442B

#define  PROFIBUS_FSPMM2_CMD_EVENT_IND                 0x0000442C
#define  PROFIBUS_FSPMM2_CMD_EVENT_RES                 0x0000442D

#define  PROFIBUS_FSPMM2_CMD_FAULT_IND                 0x0000442E
#define  PROFIBUS_FSPMM2_CMD_FAULT_RES                 0x0000442F

#define  PROFIBUS_FSPMM2_CMD_LIVE_LIST_REQ             0x00004430
#define  PROFIBUS_FSPMM2_CMD_LIVE_LIST_CNF             0x00004431

#define  PROFIBUS_FSPMM2_CMD_RESET_CONN_REQ            0x00004432
#define  PROFIBUS_FSPMM2_CMD_RESET_CONN_CNF            0x00004433

#define  PROFIBUS_FSPMM2_CMD_RANGE_END                 0x00004433


#define  PROFIBUS_FSPMM2_CMD_TIMER_IND                 0x000022F0



/*************************************************************************************/
/* defines */

/* Abort instance */
#define PROFIBUS_FSPMM2_INSTANCE_DLL         0
#define PROFIBUS_FSPMM2_INSTANCE_MSAC2M      1
#define PROFIBUS_FSPMM2_INSTANCE_USER        2

/* Subnet */
#define PROFIBUS_FSPMM2_SUBNET_NO            0
#define PROFIBUS_FSPMM2_SUBNET_LOCAL         1
#define PROFIBUS_FSPMM2_SUBNET_REMOTE        2

/* Live List */
#define PROFIBUS_FSPMM2_STATON_TYPE_PASSIVE  1
#define PROFIBUS_FSPMM2_STATON_TYPE_ACTIVE   3

/* maximum abort indications */
#define PROFIBUS_FSPMM2_MAX_ABORT_IND        8



/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__PROFIBUS_FSPMM2_PACKET)
#endif


/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task. 
 * @{
 */

/**********************************************************************************
** INIT REQ/CNF PACKET
*/
typedef struct PROFIBUS_FSPMM2_INIT_REQ_Ttag
{
  PROFIBUS_DL_BUS_PARAMETER_SET_T tBusParameter;
} PROFIBUS_FSPMM2_INIT_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_INIT_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_INIT_REQ_T tData;
 }PROFIBUS_FSPMM2_PACKET_INIT_REQ_T;

#define PROFIBUS_FSPMM2_INIT_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_INIT_REQ_T) - sizeof(PROFIBUS_DL_BUS_PARAMETER_SET_T))

typedef struct PROFIBUS_FSPMM2_PACKET_INIT_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} PROFIBUS_FSPMM2_PACKET_INIT_CNF_T;
 

/**********************************************************************************
** INITIATE REQ/CNF PACKET
*/
#define PROFIBUS_FSPMM2_ADD_ADDR_TABLE_LEN 228
typedef struct PROFIBUS_FSPMM2_ADD_ADDR_PARAMtag
{
  TLR_UINT8  bS_Type;
  TLR_UINT8  bS_Len; 
  TLR_UINT8  bD_Type;
  TLR_UINT8  bD_Len;  
  TLR_UINT8  abAddParam[PROFIBUS_FSPMM2_ADD_ADDR_TABLE_LEN];
} PROFIBUS_FSPMM2_ADD_ADDR_PARAM;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_INITIATE_REQ_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT16 usSendTimeout; 
  TLR_UINT8  bFeaturesSupported1;
  TLR_UINT8  bFeaturesSupported2;
  TLR_UINT8  bProfileFeaturesSupported1;
  TLR_UINT8  bProfileFeaturesSupported2;
  TLR_UINT16 usProfileIdentNumber;
  PROFIBUS_FSPMM2_ADD_ADDR_PARAM tAddAddrParam;  
}__TLR_PACKED_POST PROFIBUS_FSPMM2_INITIATE_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_INITIATE_CNF_POS_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT32 ulCRef;
  TLR_UINT8  bMaxLenDataUnit;
  TLR_UINT8  bFeaturesSupported1;
  TLR_UINT8  bFeaturesSupported2;
  TLR_UINT8  bProfileFeaturesSupported1;
  TLR_UINT8  bProfileFeaturesSupported2;
  TLR_UINT16 usProfileIdentNumber;
  PROFIBUS_FSPMM2_ADD_ADDR_PARAM tAddAddrParam;  
}__TLR_PACKED_POST PROFIBUS_FSPMM2_INITIATE_CNF_POS_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_INITIATE_CNF_NEG_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  bErrorDecode;
  TLR_UINT8  bErrorCode1;
  TLR_UINT8  bErrorCode2;
  TLR_UINT8  bReserved;
  TLR_UINT16 usDetail;
  TLR_UINT16 usReserved;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_INITIATE_CNF_NEG_T;

typedef struct PROFIBUS_FSPMM2_PACKET_INITIATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_INITIATE_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_INITIATE_REQ_T;

typedef union PROFIBUS_FSPMM2_INITIATE_CNF_Ttag
{
  PROFIBUS_FSPMM2_INITIATE_CNF_POS_T tCnfPos;  
  PROFIBUS_FSPMM2_INITIATE_CNF_NEG_T tCnfNeg;
} PROFIBUS_FSPMM2_INITIATE_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_INITIATE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_INITIATE_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_INITIATE_CNF_T;

#define PROFIBUS_FSPMM2_INITIATE_REQ_SIZE     (sizeof(PROFIBUS_FSPMM2_INITIATE_REQ_T)-sizeof(PROFIBUS_FSPMM2_ADD_ADDR_PARAM))
#define PROFIBUS_FSPMM2_INITIATE_CNF_SIZE_POS (sizeof(PROFIBUS_FSPMM2_INITIATE_CNF_POS_T)-sizeof(PROFIBUS_FSPMM2_ADD_ADDR_PARAM))
#define PROFIBUS_FSPMM2_INITIATE_CNF_SIZE_NEG (sizeof(PROFIBUS_FSPMM2_INITIATE_CNF_POS_T))



/**********************************************************************************
** ABORT REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_ABORT_REQ_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT8  bSubnet;
  TLR_UINT8  bInstance;
  TLR_UINT8  bReasonCode;
  TLR_UINT8  abReserved[1]; 
}__TLR_PACKED_POST PROFIBUS_FSPMM2_ABORT_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_ABORT_CNF_Ttag
{
  TLR_UINT32  ulCRef;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_ABORT_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_ABORT_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_ABORT_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_ABORT_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_ABORT_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_ABORT_CNF_T tData;
}PROFIBUS_FSPMM2_PACKET_ABORT_CNF_T;

#define PROFIBUS_FSPMM2_ABORT_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_ABORT_REQ_T))
#define PROFIBUS_FSPMM2_ABORT_CNF_SIZE (sizeof(PROFIBUS_FSPMM2_ABORT_CNF_T))


/**********************************************************************************
** ABORT IND/RES PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_ABORT_IND_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT8  bLocallyGenerated;
  TLR_UINT8  bSubnet;
  TLR_UINT8  bInstance;
  TLR_UINT8  bReasonCode;
  TLR_UINT16 usAbortDetail;
  TLR_UINT8  abReserved[2];  
}__TLR_PACKED_POST PROFIBUS_FSPMM2_ABORT_IND_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_ABORT_RES_Ttag
{
  TLR_UINT32  ulCRef;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_ABORT_RES_T;

typedef struct PROFIBUS_FSPMM2_PACKET_ABORT_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_ABORT_IND_T tData;
}PROFIBUS_FSPMM2_PACKET_ABORT_IND_T;

typedef struct PROFIBUS_FSPMM2_PACKET_ABORT_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_ABORT_RES_T tData;
}PROFIBUS_FSPMM2_PACKET_ABORT_RES_T;


/**********************************************************************************
** CLOSED IND/RES PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_CLOSED_IND_Ttag
{
  TLR_UINT32 ulCRef;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_CLOSED_IND_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_CLOSED_RES_Ttag
{
  TLR_UINT32  ulCRef;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_CLOSED_RES_T;

typedef struct PROFIBUS_FSPMM2_PACKET_CLOSED_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_CLOSED_IND_T tData;
}PROFIBUS_FSPMM2_PACKET_CLOSED_IND_T;

typedef struct PROFIBUS_FSPMM2_PACKET_CLOSED_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_CLOSED_RES_T tData;
}PROFIBUS_FSPMM2_PACKET_CLOSED_RES_T;


/**********************************************************************************
** READ REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_REQ_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_CNF_POS_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_CNF_POS_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_CNF_NEG_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
  TLR_UINT8  bErrorDecode;
  TLR_UINT8  bErrorCode1;
  TLR_UINT8  bErrorCode2;
  TLR_UINT8  bReserved;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_CNF_NEG_T;

typedef union PROFIBUS_FSPMM2_READ_CNF_Ttag
{
  PROFIBUS_FSPMM2_READ_CNF_POS_T tCnfPos;    
  PROFIBUS_FSPMM2_READ_CNF_NEG_T tCnfNeg;  
} PROFIBUS_FSPMM2_READ_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_READ_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_READ_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_CNF_Ttag
{
  TLR_PACKET_HEADER_T        tHead;
  PROFIBUS_FSPMM2_READ_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_READ_CNF_T;

#define PROFIBUS_FSPMM2_READ_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_READ_REQ_T))
#define PROFIBUS_FSPMM2_READ_CNF_POS_SIZE (sizeof(PROFIBUS_FSPMM2_READ_CNF_POS_T)-PROFIBUS_FSPM_MAX_IO_DATA_LEN)
#define PROFIBUS_FSPMM2_READ_CNF_NEG_SIZE (sizeof(PROFIBUS_FSPMM2_READ_CNF_NEG_T))


/**********************************************************************************
** WRITE REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_WRITE_REQ_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_WRITE_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_WRITE_CNF_NEG_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
  TLR_UINT8  bErrorDecode;
  TLR_UINT8  bErrorCode1;
  TLR_UINT8  bErrorCode2;
  TLR_UINT8  bReserved;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_WRITE_CNF_NEG_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_WRITE_CNF_POS_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_WRITE_CNF_POS_T;

typedef union PROFIBUS_FSPMM2_WRITE_CNF_Ttag
{
  PROFIBUS_FSPMM2_WRITE_CNF_POS_T tCnfPos;    
  PROFIBUS_FSPMM2_WRITE_CNF_NEG_T tCnfNeg;  
} PROFIBUS_FSPMM2_WRITE_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_WRITE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_WRITE_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_WRITE_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_WRITE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_WRITE_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_WRITE_CNF_T;
                                                                                                                                                                                                                 
#define PROFIBUS_FSPMM2_WRITE_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_WRITE_REQ_T)-PROFIBUS_FSPM_MAX_IO_DATA_LEN)
#define PROFIBUS_FSPMM2_WRITE_CNF_POS_SIZE (sizeof(PROFIBUS_FSPMM2_WRITE_CNF_POS_T))
#define PROFIBUS_FSPMM2_WRITE_CNF_NEG_SIZE (sizeof(PROFIBUS_FSPMM2_WRITE_CNF_NEG_T))


/**********************************************************************************
** DATA TRANSPORT REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_DATA_TRANSPORT_REQ_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_DATA_TRANSPORT_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_NEG_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
  TLR_UINT8  bErrorDecode;
  TLR_UINT8  bErrorCode1;
  TLR_UINT8  bErrorCode2;
  TLR_UINT8  bReserved;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_NEG_T;

typedef struct PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_POS_Ttag
{
  TLR_UINT32 ulCRef;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulLength;
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_POS_T;

typedef union PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_Ttag
{
  PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_POS_T tCnfPos;    
  PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_NEG_T tCnfNeg;  
} PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_DATA_TRANSPORT_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_DATA_TRANSPORT_REQ_T tData;
}PROFIBUS_FSPMM2_PACKET_DATA_TRANSPORT_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_DATA_TRANSPORT_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_DATA_TRANSPORT_CNF_T;

#define PROFIBUS_FSPMM2_DATA_TRANSPORT_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_DATA_TRANSPORT_REQ_T)-PROFIBUS_FSPM_MAX_IO_DATA_LEN)
#define PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_POS_SIZE (sizeof(PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_POS_T)-PROFIBUS_FSPM_MAX_IO_DATA_LEN)
#define PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_NEG_SIZE (sizeof(PROFIBUS_FSPMM2_DATA_TRANSPORT_CNF_NEG_T))


/**********************************************************************************
** READ SLAVE DIAG REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_SLAVE_DIAG_REQ_Ttag
{
  TLR_UINT32 ulRemAdd;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_SLAVE_DIAG_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_SLAVE_DIAG_CNF_Ttag
{
  TLR_UINT32 ulRemAdd;
  PROFIBUS_FSPMM_DIAGNOSTIC_DATA_T  tDiagnostic;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_SLAVE_DIAG_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_SLAVE_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_READ_SLAVE_DIAG_REQ_T tData;
}PROFIBUS_FSPMM2_PACKET_READ_SLAVE_DIAG_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_SLAVE_DIAG_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_READ_SLAVE_DIAG_CNF_T tData;
}PROFIBUS_FSPMM2_PACKET_READ_SLAVE_DIAG_CNF_T;


#define PROFIBUS_FSPMM2_READ_SLAVE_DIAG_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_READ_SLAVE_DIAG_REQ_T))
#define PROFIBUS_FSPMM2_READ_SLAVE_DIAG_CNF_SIZE (sizeof(PROFIBUS_FSPMM2_READ_SLAVE_DIAG_CNF_T) - sizeof(PROFIBUS_FSPMM_DIAGNOSTIC_DATA_T) )


/**********************************************************************************
** READ INPUT DIAG REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_INPUT_REQ_Ttag
{
  TLR_UINT32 ulRemAdd;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_INPUT_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_INPUT_CNF_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_INPUT_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_INPUT_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_READ_INPUT_REQ_T tData;
}PROFIBUS_FSPMM2_PACKET_READ_INPUT_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_INPUT_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_READ_INPUT_CNF_T tData;
}PROFIBUS_FSPMM2_PACKET_READ_INPUT_CNF_T;

#define PROFIBUS_FSPMM2_READ_INPUT_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_READ_INPUT_REQ_T))
#define PROFIBUS_FSPMM2_READ_INPUT_CNF_SIZE (sizeof(PROFIBUS_FSPMM2_READ_INPUT_REQ_T))


/**********************************************************************************
** READ OUTPUT DIAG REQ/CNF PACKET
*/
  
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_OUTPUT_REQ_Ttag
{
  TLR_UINT32 ulRemAdd;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_OUTPUT_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_READ_OUTPUT_CNF_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_READ_OUTPUT_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_OUTPUT_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_READ_OUTPUT_REQ_T tData;
}PROFIBUS_FSPMM2_PACKET_READ_OUTPUT_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_READ_OUTPUT_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_READ_OUTPUT_CNF_T tData;
}PROFIBUS_FSPMM2_PACKET_READ_OUTPUT_CNF_T;

#define PROFIBUS_FSPMM2_READ_OUTPUT_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_READ_OUTPUT_REQ_T))
#define PROFIBUS_FSPMM2_READ_OUTPUT_CNF_SIZE (sizeof(PROFIBUS_FSPMM2_READ_OUTPUT_REQ_T))


/**********************************************************************************
** GET_MASTER_DIAG REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_GET_MASTER_DIAG_REQ_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  bIdentifier;
  TLR_UINT8  abReserved[3];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_GET_MASTER_DIAG_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_GET_MASTER_DIAG_CNF_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  bIdentifier;
  TLR_UINT8  abReserved[3];
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_GET_MASTER_DIAG_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_GET_MASTER_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_GET_MASTER_DIAG_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_GET_MASTER_DIAG_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_GET_MASTER_DIAG_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_GET_MASTER_DIAG_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_GET_MASTER_DIAG_CNF_T;

#define PROFIBUS_FSPMM2_GET_MASTER_DIAG_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_GET_MASTER_DIAG_REQ_T))
#define PROFIBUS_FSPMM2_GET_MASTER_DIAG_CNF_SIZE (sizeof(PROFIBUS_FSPMM2_GET_MASTER_DIAG_REQ_T))


/**********************************************************************************
** SET_SLAVE_ADD REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_SET_SLAVE_ADD_REQ_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  bNewSlaveAdd;
  TLR_UINT16 usIdentNumber;
  TLR_UINT8  bNoAddChg;
  TLR_UINT8  abRemSlaveData[240];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_SET_SLAVE_ADD_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_SET_SLAVE_ADD_CNF_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  bNewSlaveAdd;
  TLR_UINT16 usIdentNumber;
  TLR_UINT8  bNoAddChg;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_SET_SLAVE_ADD_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_SET_SLAVE_ADD_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_SET_SLAVE_ADD_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_SET_SLAVE_ADD_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_SET_SLAVE_ADD_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_SET_SLAVE_ADD_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_SET_SLAVE_ADD_CNF_T;
                                           
#define PROFIBUS_FSPMM2_SET_SLAVE_ADD_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_SET_SLAVE_ADD_REQ_T)-240)
#define PROFIBUS_FSPMM2_SET_SLAVE_ADD_CNF_SIZE (sizeof(PROFIBUS_FSPMM2_SET_SLAVE_ADD_CNF_T))


/**********************************************************************************
** GET_CFG REQ/CNF PACKET
*/
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_GET_CFG_REQ_Ttag
{
  TLR_UINT32 ulRemAdd;
}__TLR_PACKED_POST PROFIBUS_FSPMM2_GET_CFG_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_GET_CFG_CNF_Ttag
{
  TLR_UINT32 ulRemAdd;
  TLR_UINT8  abData[PROFIBUS_FSPM_MAX_IO_DATA_LEN];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_GET_CFG_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_GET_CFG_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_GET_CFG_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_GET_CFG_REQ_T; 

typedef struct PROFIBUS_FSPMM2_PACKET_GET_CFG_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_GET_CFG_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_GET_CFG_CNF_T; 

#define PROFIBUS_FSPMM2_GET_CFG_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_GET_CFG_REQ_T))
#define PROFIBUS_FSPMM2_GET_CFG_CNF_SIZE (sizeof(PROFIBUS_FSPMM2_GET_CFG_REQ_T))


/**********************************************************************************
** LIVE_LIST REQ/CNF PACKET
*/
#define PROFIBUS_FSPMM2_LIVE_LIST_SIZE 128
typedef __TLR_PACKED_PRE struct PROFIBUS_FSPMM2_LIVE_LIST_CNF_Ttag
{
  TLR_UINT8  abLiveList[PROFIBUS_FSPMM2_LIVE_LIST_SIZE];
}__TLR_PACKED_POST PROFIBUS_FSPMM2_LIVE_LIST_CNF_T;

typedef struct PROFIBUS_FSPMM2_PACKET_LIVE_LIST_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} PROFIBUS_FSPMM2_PACKET_LIVE_LIST_REQ_T; 

typedef struct PROFIBUS_FSPMM2_PACKET_LIVE_LIST_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_LIVE_LIST_CNF_T tData;
} PROFIBUS_FSPMM2_PACKET_LIVE_LIST_CNF_T; 

#define PROFIBUS_FSPMM2_LIVE_LIST_REQ_SIZE     (0)
#define PROFIBUS_FSPMM2_LIVE_LIST_CNF_NEG_SIZE (0)
#define PROFIBUS_FSPMM2_LIVE_LIST_CNF_POS_SIZE (sizeof(PROFIBUS_FSPMM2_LIVE_LIST_CNF_T))

/**********************************************************************************
 ** RESET REQ/CNF PACKET
 */
typedef struct PROFIBUS_FSPMM2_RESET_CONN_REQ_Ttag
{
  TLR_UINT32 ulRemAddr;
} PROFIBUS_FSPMM2_RESET_CONN_REQ_T;

typedef struct PROFIBUS_FSPMM2_PACKET_RESET_CONN_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  PROFIBUS_FSPMM2_RESET_CONN_REQ_T tData;
} PROFIBUS_FSPMM2_PACKET_RESET_CONN_REQ_T;

#define PROFIBUS_FSPMM2_RESET_CONN_REQ_SIZE (sizeof(PROFIBUS_FSPMM2_RESET_CONN_REQ_T))

typedef struct PROFIBUS_FSPMM2_PACKET_RESET_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
}PROFIBUS_FSPMM2_PACKET_RESET_CONN_CNF_T;

#define PROFIBUS_FSPMM2_RESET_CONN_CNF_SIZE (0)





/** @} */

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__PROFIBUS_FSPMM2_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __PROFIBUS_FSPMM2_PUBLIC_H */
